/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.LinkedTreeMap$1;
import com.google.gson.internal.LinkedTreeMap$EntrySet;
import com.google.gson.internal.LinkedTreeMap$KeySet;
import com.google.gson.internal.LinkedTreeMap$Node;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import pro.gravit.launcher.alEXSerVErSwSq;

public final class LinkedTreeMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final Comparator<Comparable> NATURAL_ORDER = new LinkedTreeMap$1();
    private final Comparator<? super K> comparator;
    private final boolean allowNullValues;
    LinkedTreeMap$Node<K, V> root;
    int size = 0;
    int modCount = 0;
    final LinkedTreeMap$Node<K, V> header;
    private LinkedTreeMap$EntrySet entrySet;
    private LinkedTreeMap$KeySet keySet;

    public LinkedTreeMap() {
        this(NATURAL_ORDER, true);
    }

    public LinkedTreeMap(boolean bl) {
        this(NATURAL_ORDER, bl);
    }

    public LinkedTreeMap(Comparator<? super K> comparator, boolean bl) {
        this.comparator = comparator != null ? comparator : NATURAL_ORDER;
        this.allowNullValues = bl;
        this.header = new LinkedTreeMap$Node(bl);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object object) {
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node = this.findByObject(object);
        return linkedTreeMap$Node != null ? (V)linkedTreeMap$Node.value : null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.findByObject(object) != null;
    }

    @Override
    @alEXSerVErSwSq
    public V put(K k, V v) {
        if (k == null) {
            throw new NullPointerException("key == null");
        }
        if (v == null && !this.allowNullValues) {
            throw new NullPointerException("value == null");
        }
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node = this.find(k, true);
        Object v2 = linkedTreeMap$Node.value;
        linkedTreeMap$Node.value = v;
        return v2;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node = this.header;
        linkedTreeMap$Node.prev = linkedTreeMap$Node;
        linkedTreeMap$Node.next = linkedTreeMap$Node.prev;
    }

    @Override
    public V remove(Object object) {
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node = this.removeInternalByKey(object);
        return linkedTreeMap$Node != null ? (V)linkedTreeMap$Node.value : null;
    }

    LinkedTreeMap$Node<K, V> find(K k, boolean bl) {
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node;
        Object object;
        Comparator<K> comparator = this.comparator;
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node2 = this.root;
        int n = 0;
        if (linkedTreeMap$Node2 != null) {
            object = comparator == NATURAL_ORDER ? (Comparable)k : null;
            while (true) {
                int n2 = n = object != null ? object.compareTo(linkedTreeMap$Node2.key) : comparator.compare(k, linkedTreeMap$Node2.key);
                if (n == 0) {
                    return linkedTreeMap$Node2;
                }
                LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node = n < 0 ? linkedTreeMap$Node2.left : linkedTreeMap$Node2.right;
                if (linkedTreeMap$Node == null) break;
                linkedTreeMap$Node2 = linkedTreeMap$Node;
            }
        }
        if (!bl) {
            return null;
        }
        object = this.header;
        if (linkedTreeMap$Node2 == null) {
            if (comparator == NATURAL_ORDER && !(k instanceof Comparable)) {
                throw new ClassCastException(k.getClass().getName() + " is not Comparable");
            }
            linkedTreeMap$Node = new LinkedTreeMap$Node<K, V>(this.allowNullValues, linkedTreeMap$Node2, k, object, ((LinkedTreeMap$Node)object).prev);
            this.root = linkedTreeMap$Node;
        } else {
            linkedTreeMap$Node = new LinkedTreeMap$Node<K, V>(this.allowNullValues, linkedTreeMap$Node2, k, object, ((LinkedTreeMap$Node)object).prev);
            if (n < 0) {
                linkedTreeMap$Node2.left = linkedTreeMap$Node;
            } else {
                linkedTreeMap$Node2.right = linkedTreeMap$Node;
            }
            this.rebalance(linkedTreeMap$Node2, true);
        }
        ++this.size;
        ++this.modCount;
        return linkedTreeMap$Node;
    }

    LinkedTreeMap$Node<K, V> findByObject(Object object) {
        try {
            return object != null ? this.find(object, false) : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    LinkedTreeMap$Node<K, V> findByEntry(Map.Entry<?, ?> entry) {
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node = this.findByObject(entry.getKey());
        boolean bl = linkedTreeMap$Node != null && LinkedTreeMap.equal(linkedTreeMap$Node.value, entry.getValue());
        return bl ? linkedTreeMap$Node : null;
    }

    private static boolean equal(Object object, Object object2) {
        return Objects.equals(object, object2);
    }

    void removeInternal(LinkedTreeMap$Node<K, V> linkedTreeMap$Node, boolean bl) {
        if (bl) {
            linkedTreeMap$Node.prev.next = linkedTreeMap$Node.next;
            linkedTreeMap$Node.next.prev = linkedTreeMap$Node.prev;
        }
        LinkedTreeMap$Node linkedTreeMap$Node2 = linkedTreeMap$Node.left;
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.right;
        LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node.parent;
        if (linkedTreeMap$Node2 != null && linkedTreeMap$Node3 != null) {
            LinkedTreeMap$Node linkedTreeMap$Node5 = linkedTreeMap$Node2.height > linkedTreeMap$Node3.height ? linkedTreeMap$Node2.last() : linkedTreeMap$Node3.first();
            this.removeInternal(linkedTreeMap$Node5, false);
            int n = 0;
            linkedTreeMap$Node2 = linkedTreeMap$Node.left;
            if (linkedTreeMap$Node2 != null) {
                n = linkedTreeMap$Node2.height;
                linkedTreeMap$Node5.left = linkedTreeMap$Node2;
                linkedTreeMap$Node2.parent = linkedTreeMap$Node5;
                linkedTreeMap$Node.left = null;
            }
            int n2 = 0;
            linkedTreeMap$Node3 = linkedTreeMap$Node.right;
            if (linkedTreeMap$Node3 != null) {
                n2 = linkedTreeMap$Node3.height;
                linkedTreeMap$Node5.right = linkedTreeMap$Node3;
                linkedTreeMap$Node3.parent = linkedTreeMap$Node5;
                linkedTreeMap$Node.right = null;
            }
            linkedTreeMap$Node5.height = Math.max(n, n2) + 1;
            this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node5);
            return;
        }
        if (linkedTreeMap$Node2 != null) {
            this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node2);
            linkedTreeMap$Node.left = null;
        } else if (linkedTreeMap$Node3 != null) {
            this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node3);
            linkedTreeMap$Node.right = null;
        } else {
            this.replaceInParent(linkedTreeMap$Node, null);
        }
        this.rebalance(linkedTreeMap$Node4, false);
        --this.size;
        ++this.modCount;
    }

    LinkedTreeMap$Node<K, V> removeInternalByKey(Object object) {
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node = this.findByObject(object);
        if (linkedTreeMap$Node != null) {
            this.removeInternal(linkedTreeMap$Node, true);
        }
        return linkedTreeMap$Node;
    }

    private void replaceInParent(LinkedTreeMap$Node<K, V> linkedTreeMap$Node, LinkedTreeMap$Node<K, V> linkedTreeMap$Node2) {
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.parent;
        linkedTreeMap$Node.parent = null;
        if (linkedTreeMap$Node2 != null) {
            linkedTreeMap$Node2.parent = linkedTreeMap$Node3;
        }
        if (linkedTreeMap$Node3 != null) {
            if (linkedTreeMap$Node3.left == linkedTreeMap$Node) {
                linkedTreeMap$Node3.left = linkedTreeMap$Node2;
            } else {
                assert (linkedTreeMap$Node3.right == linkedTreeMap$Node);
                linkedTreeMap$Node3.right = linkedTreeMap$Node2;
            }
        } else {
            this.root = linkedTreeMap$Node2;
        }
    }

    private void rebalance(LinkedTreeMap$Node<K, V> linkedTreeMap$Node, boolean bl) {
        LinkedTreeMap$Node<K, V> linkedTreeMap$Node2 = linkedTreeMap$Node;
        while (linkedTreeMap$Node2 != null) {
            int n;
            LinkedTreeMap$Node linkedTreeMap$Node3;
            int n2;
            int n3;
            LinkedTreeMap$Node linkedTreeMap$Node4;
            LinkedTreeMap$Node linkedTreeMap$Node5;
            int n4;
            LinkedTreeMap$Node linkedTreeMap$Node6 = linkedTreeMap$Node2.left;
            int n5 = linkedTreeMap$Node6 != null ? linkedTreeMap$Node6.height : 0;
            int n6 = n5 - (n4 = (linkedTreeMap$Node5 = linkedTreeMap$Node2.right) != null ? linkedTreeMap$Node5.height : 0);
            if (n6 == -2) {
                linkedTreeMap$Node4 = linkedTreeMap$Node5.left;
                n3 = linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0;
                n = n3 - (n2 = (linkedTreeMap$Node3 = linkedTreeMap$Node5.right) != null ? linkedTreeMap$Node3.height : 0);
                if (n == -1 || n == 0 && !bl) {
                    this.rotateLeft(linkedTreeMap$Node2);
                } else {
                    assert (n == 1);
                    this.rotateRight(linkedTreeMap$Node5);
                    this.rotateLeft(linkedTreeMap$Node2);
                }
                if (bl) {
                    break;
                }
            } else if (n6 == 2) {
                linkedTreeMap$Node4 = linkedTreeMap$Node6.left;
                n3 = linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0;
                n = n3 - (n2 = (linkedTreeMap$Node3 = linkedTreeMap$Node6.right) != null ? linkedTreeMap$Node3.height : 0);
                if (n == 1 || n == 0 && !bl) {
                    this.rotateRight(linkedTreeMap$Node2);
                } else {
                    assert (n == -1);
                    this.rotateLeft(linkedTreeMap$Node6);
                    this.rotateRight(linkedTreeMap$Node2);
                }
                if (bl) {
                    break;
                }
            } else if (n6 == 0) {
                linkedTreeMap$Node2.height = n5 + 1;
                if (bl) {
                    break;
                }
            } else {
                assert (n6 == -1 || n6 == 1);
                linkedTreeMap$Node2.height = Math.max(n5, n4) + 1;
                if (!bl) break;
            }
            linkedTreeMap$Node2 = linkedTreeMap$Node2.parent;
        }
    }

    private void rotateLeft(LinkedTreeMap$Node<K, V> linkedTreeMap$Node) {
        LinkedTreeMap$Node linkedTreeMap$Node2 = linkedTreeMap$Node.left;
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.right;
        LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node3.left;
        LinkedTreeMap$Node linkedTreeMap$Node5 = linkedTreeMap$Node3.right;
        linkedTreeMap$Node.right = linkedTreeMap$Node4;
        if (linkedTreeMap$Node4 != null) {
            linkedTreeMap$Node4.parent = linkedTreeMap$Node;
        }
        this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node3);
        linkedTreeMap$Node3.left = linkedTreeMap$Node;
        linkedTreeMap$Node.parent = linkedTreeMap$Node3;
        linkedTreeMap$Node.height = Math.max(linkedTreeMap$Node2 != null ? linkedTreeMap$Node2.height : 0, linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0) + 1;
        linkedTreeMap$Node3.height = Math.max(linkedTreeMap$Node.height, linkedTreeMap$Node5 != null ? linkedTreeMap$Node5.height : 0) + 1;
    }

    private void rotateRight(LinkedTreeMap$Node<K, V> linkedTreeMap$Node) {
        LinkedTreeMap$Node linkedTreeMap$Node2 = linkedTreeMap$Node.left;
        LinkedTreeMap$Node linkedTreeMap$Node3 = linkedTreeMap$Node.right;
        LinkedTreeMap$Node linkedTreeMap$Node4 = linkedTreeMap$Node2.left;
        LinkedTreeMap$Node linkedTreeMap$Node5 = linkedTreeMap$Node2.right;
        linkedTreeMap$Node.left = linkedTreeMap$Node5;
        if (linkedTreeMap$Node5 != null) {
            linkedTreeMap$Node5.parent = linkedTreeMap$Node;
        }
        this.replaceInParent(linkedTreeMap$Node, linkedTreeMap$Node2);
        linkedTreeMap$Node2.right = linkedTreeMap$Node;
        linkedTreeMap$Node.parent = linkedTreeMap$Node2;
        linkedTreeMap$Node.height = Math.max(linkedTreeMap$Node3 != null ? linkedTreeMap$Node3.height : 0, linkedTreeMap$Node5 != null ? linkedTreeMap$Node5.height : 0) + 1;
        linkedTreeMap$Node2.height = Math.max(linkedTreeMap$Node.height, linkedTreeMap$Node4 != null ? linkedTreeMap$Node4.height : 0) + 1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedTreeMap$EntrySet linkedTreeMap$EntrySet = this.entrySet;
        if (linkedTreeMap$EntrySet == null) {
            linkedTreeMap$EntrySet = this.entrySet = new LinkedTreeMap$EntrySet(this);
        }
        return linkedTreeMap$EntrySet;
    }

    @Override
    public Set<K> keySet() {
        LinkedTreeMap$KeySet linkedTreeMap$KeySet = this.keySet;
        if (linkedTreeMap$KeySet == null) {
            linkedTreeMap$KeySet = this.keySet = new LinkedTreeMap$KeySet(this);
        }
        return linkedTreeMap$KeySet;
    }

    private Object writeReplace() {
        return new LinkedHashMap(this);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Deserialization is unsupported");
    }
}

