/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import pro.gravit.launcher.core.api.LauncherAPI;
import pro.gravit.launcher.core.api.features.AuthFeatureAPI;
import pro.gravit.launcher.core.api.features.CoreFeatureAPI;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.features.UserFeatureAPI;

public final class LauncherAPIHolder {
    private static volatile CoreFeatureAPI coreAPI;
    private static volatile LauncherAPI api;
    private static volatile Function<String, LauncherAPI> createApiFactory;
    private static final Map<String, LauncherAPI> map;

    public static void setCoreAPI(CoreFeatureAPI coreFeatureAPI) {
        coreAPI = coreFeatureAPI;
    }

    public static void setApi(LauncherAPI launcherAPI) {
        api = launcherAPI;
    }

    public static void setCreateApiFactory(Function<String, LauncherAPI> function) {
        createApiFactory = function;
    }

    public static void changeAuthId(String string) {
        api = map.computeIfAbsent(string, createApiFactory);
    }

    public static LauncherAPI get() {
        return api;
    }

    public static LauncherAPI get(String string) {
        return map.computeIfAbsent(string, createApiFactory);
    }

    public static CoreFeatureAPI core() {
        return coreAPI;
    }

    public static AuthFeatureAPI auth() {
        if (api == null) {
            throw new UnsupportedOperationException();
        }
        return api.auth();
    }

    public static UserFeatureAPI user() {
        if (api == null) {
            throw new UnsupportedOperationException();
        }
        return api.user();
    }

    public static ProfileFeatureAPI profile() {
        if (api == null) {
            throw new UnsupportedOperationException();
        }
        return api.profile();
    }

    public static void set(LauncherAPI launcherAPI) {
        api = launcherAPI;
    }

    static {
        map = new ConcurrentHashMap<String, LauncherAPI>();
    }
}

